<?php
session_start();
error_reporting(0);
include('includes/config.php');
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="description" content="About Fairly Used Electronics - Your trusted companion in finding and caring for the perfect pet.">
    <meta name="author" content="">
       
    <meta name="keywords" content="pets, puppies, kittens, pet care, dog breeds, cat breeds">
       
    <meta name="robots" content="all">

        <title>Fairly Used Eelectronics | About Us</title>

       
    <!-- Bootstrap Core CSS -->
       
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
       
    <!-- Customizable CSS -->
       
    <link rel="stylesheet" href="assets/css/main.css">
       
    <link rel="stylesheet" href="assets/css/green.css">
       
    <link rel="stylesheet" href="assets/css/owl.carousel.css">
    <link rel="stylesheet" href="assets/css/owl.transitions.css">
    <link href="assets/css/lightbox.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/rateit.css">
    <link rel="stylesheet" href="assets/css/bootstrap-select.min.css">

    <!-- Icons/Glyphs -->
    <link rel="stylesheet" href="assets/css/font-awesome.min.css">

           
    <!-- Fonts --> 
    <link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,700' rel='stylesheet' type='text/css'>

    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- ============================================================= -->
    <!-- ============== CUSTOM STYLES FOR REDESIGN =================== -->
    <!-- ============================================================= -->
    <style>
        body {
            background-color: #f9f9f9;
        }


        .about-hero {
            background: linear-gradient(rgba(45, 52, 61, 0.6), rgba(45, 52, 61, 0.6)), url('assets/about-img/photo-1450778869180-41d0601e046e.webp') no-repeat center center;
            background-size: cover;
            color: white;
            padding: 100px 0;
            text-align: center;
            margin-bottom: 60px;
        }

        .about-hero h1 {
            font-size: 48px;
            font-weight: 700;
            text-shadow: 2px 2px 8px rgba(0, 0, 0, 0.5);
            color: white;
        }

        .about-hero .lead {
            font-size: 22px;
            font-weight: 300;
            max-width: 600px;
            margin: 0 auto;
        }

        .section-title {
            text-align: center;
            margin-bottom: 50px;
            position: relative;
        }

        .section-title h2 {
            font-size: 36px;
            font-weight: 500;
            margin-bottom: 15px;
            color: #333;
        }

        .section-title:after {
            content: '';
            display: block;
            width: 70px;
            height: 4px;
            background: #59b210;
            /* Using your theme's green color */
            border-radius: 2px;
            margin: 15px auto;
        }

        /* Card design for features */
        .feature-card {
            background: #ffffff;
            text-align: center;
            padding: 35px 25px;
            border-radius: 8px;
            transition: all 0.3s ease;
            margin-bottom: 30px;
            height: 100%;
            border: 1px solid #e9e9e9;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.1);
        }

        .feature-icon {
            font-size: 45px;
            margin-bottom: 20px;
            color: #59b210;
            width: 80px;
            height: 80px;
            line-height: 80px;
            background: #f0f9e9;
            border-radius: 50%;
            display: inline-block;
        }

        .feature-card h3 {
            font-size: 20px;
            font-weight: 500;
            margin-top: 0;
            margin-bottom: 15px;
        }

        /* Call-to-action banner */
        .mid-banner {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('assets/about-img/photo-1450778869180-41d0601e046e.webp') no-repeat fixed center center;
            background-size: cover;
            color: white;
            padding: 100px 0;
            text-align: center;
            margin: 60px 0;
        }

        .mid-banner h2 {
            font-size: 40px;
            font-weight: 700;
            color: white;
        }

        /* "Why Choose Us" section */
        .promise-box {
            background: #fff;
            padding: 25px;
            border-radius: 5px;
            margin-bottom: 30px;
            border-left: 5px solid #59b210;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }

        .promise-box h4 {
            margin-top: 0;
            font-size: 18px;
            color: #333;
        }

        .promise-box .fa {
            margin-right: 10px;
            color: #59b210;
        }

        /* Team member card */
        .team-card {
            text-align: center;
            margin-bottom: 30px;
            background: #fff;
            padding: 30px 15px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }

        .team-card img {
            width: 140px;
            height: 140px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 20px;
            border: 6px solid #f1f1f1;
        }

        .team-card h4 {
            font-size: 20px;
            margin-bottom: 5px;
        }

        .team-card p {
            color: #777;
            margin-bottom: 15px;
        }

        .team-social a {
            color: #999;
            margin: 0 8px;
            font-size: 18px;
        }

        .team-social a:hover {
            color: #59b210;
        }

    </style>
</head>
   

<body class="cnt-home">

    <!-- ============================================== HEADER ============================================== -->
    <header class="header-style-1">
        <?php include('includes/top-header.php');?>
        <?php include('includes/main-header.php');?>
        <?php include('includes/menu-bar.php');?>
    </header>
    <!-- ============================================== HEADER : END ============================================== -->

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="home.html">Home</a></li>
                    <li class='active'>About Us</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <!-- Hero Section -->
    <div class="about-hero">
        <div class="container">
            <h1 class="wow fadeInDown">About Fairly Used Electronics</h1>
            <p class="lead wow fadeInUp" data-wow-delay="0.2s">Your trusted companion in finding and caring for the perfect pet</p>
        </div>
    </div>

    <div class="body-content">
    <div class="container">
        <!-- Welcome Section -->
        <div class="row">
            <div class="col-md-10 col-md-offset-1">
                <div class="section-title wow fadeIn">
                    <h2>Welcome to Fairly Used Electronics</h2>
                </div>
                <p class="text-center lead wow fadeInUp" data-wow-delay="0.2s">
                    At Fairly Used Electronics, we believe technology should be affordable, reliable, and accessible to everyone. That’s why we specialize in high-quality pre-owned smartphones, laptops, and gadgets that give you premium performance without the premium price.
                </p>
                <p class="text-center lead wow fadeInUp" data-wow-delay="0.2s">
                    For years, we’ve been helping students, professionals, and families find the right device — from flagship iPhones and Samsung Galaxy phones to powerful Dell, HP, and MacBook laptops. Every product is carefully inspected, tested, and certified to meet our strict quality standards.
                </p>
                <p class="text-center lead wow fadeInUp" data-wow-delay="0.2s">
                    Whether you’re upgrading your smartphone, replacing your laptop, or shopping for a budget-friendly gift, Fairly Used Electronics is here to make technology affordable and dependable for you.
                </p>
            </div>
        </div>

        <!-- Promise Section -->
        <div class="row">
            <div class="col-md-10 col-md-offset-1">
                <div class="section-title wow fadeIn">
                    <h2>Our Promise</h2>
                </div>
                <div class="col-md-12">
                    <div class="promise-box wow fadeInLeft">
                        <p>At Fairly Used Electronics, we promise:</p>
                        <h4><i class="fa fa-check-circle"></i> To bring you only genuine and certified used devices.</h4>
                        <h4><i class="fa fa-check-circle"></i> To provide full product details, specifications, and condition reports.</h4>
                        <h4><i class="fa fa-check-circle"></i> To create a safe and trustworthy shopping experience for all customers.</h4>
                        <p>Because buying tech should be smart, sustainable, and stress-free. 💻📱</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- What We Offer Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="section-title wow fadeIn">
                    <h2>What We Offer</h2>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.1s">
                    <div class="feature-icon"><i class="fa fa-mobile"></i></div>
                    <h3>Wide Range of Devices</h3>
                    <p>From iPhones and Samsung Galaxy phones to MacBooks and gaming laptops for everyone.</p>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.2s">
                    <div class="feature-icon"><i class="fa fa-cogs"></i></div>
                    <h3>Certified Quality</h3>
                    <p>Each device is inspected, tested, and restored to ensure full functionality and excellent performance.</p>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.3s">
                    <div class="feature-icon"><i class="fa fa-shopping-cart"></i></div>
                    <h3>Easy Shopping Experience</h3>
                    <p>Browse, compare, and order online with a smooth and secure checkout process.</p>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.4s">
                    <div class="feature-icon"><i class="fa fa-heart"></i></div>
                    <h3>Affordable Pricing</h3>
                    <p>Get premium devices at unbeatable prices — perfect for students, businesses, and families.</p>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.5s">
                    <div class="feature-icon"><i class="fa fa-globe"></i></div>
                    <h3>Sustainable Choice</h3>
                    <p>By choosing refurbished and fairly used devices, you help reduce e-waste and support a greener planet.</p>
                </div>
            </div>

            <div class="col-md-4 col-sm-6">
                <div class="feature-card wow fadeInUp" data-wow-delay="0.6s">
                    <div class="feature-icon"><i class="fa fa-headphones"></i></div>
                    <h3>Customer Support</h3>
                    <p>Our team is here to answer your questions and guide you to the right device for your needs.</p>
                </div>
            </div>
        </div>

        <!-- Middle Banner -->
        <div class="mid-banner wow fadeIn">
            <div class="container">
                <h2 class="wow fadeInUp">Upgrade Smart, Save Big</h2>
                <p class="wow fadeInUp" data-wow-delay="0.2s">
                    At Fairly Used Electronics, we make owning top-brand electronics affordable, reliable, and eco-friendly.
                </p>
                <a href="category.php?cid=1&view=all" class="btn btn-primary btn-lg wow fadeInUp" data-wow-delay="0.4s">
                    Shop All Devices
                </a>
            </div>
        </div>

        <!-- Why Choose Us Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="section-title wow fadeIn">
                    <h2>Why Choose Fairly Used Electronics?</h2>
                </div>
            </div>

            <div class="col-md-6">
                <div class="promise-box wow fadeInLeft">
                    <h4><i class="fa fa-check-circle"></i> Expert Knowledge</h4>
                    <p>We provide clear specs, condition grading, and comparisons exactly what you need.</p>
                </div>
            </div>

            <div class="col-md-6">
                <div class="promise-box wow fadeInRight">
                    <h4><i class="fa fa-check-circle"></i> Passion for Tech</h4>
                    <p>We’re tech enthusiasts committed to helping you get the best value out of your devices.</p>
                </div>
            </div>

            <div class="col-md-6">
                <div class="promise-box wow fadeInLeft" data-wow-delay="0.2s">
                    <h4><i class="fa fa-check-circle"></i> Quality & Trust</h4>
                    <p>Every device is tested and certified, so you can shop with confidence and peace of mind.</p>
                </div>
            </div>

            <div class="col-md-6">
                <div class="promise-box wow fadeInRight" data-wow-delay="0.2s">
                    <h4><i class="fa fa-check-circle"></i> Ongoing Support</h4>
                    <p>Our customer service doesn’t stop after purchase — we’re here for your entire tech journey.</p>
                </div>
            </div>
        </div>

        <!-- Team Section -->
        <div class="row" style="margin-top: 40px;">
            <div class="col-md-12">
                <div class="section-title wow fadeIn">
                    <h2>Meet Our Team</h2>
                </div>
            </div>

            <div class="col-md-4 col-sm-4">
                <div class="team-card wow fadeInUp" data-wow-delay="0.1s">
                    <img src="assets/about-img/photo-1560250097-0b93528c311a.avif" alt="Team Member">
                    <h4>John Peterson</h4>
                    <p>Founder &amp; CEO</p>
                    <div class="team-social">
                        <a href="#"><i class="fa fa-twitter"></i></a>
                        <a href="#"><i class="fa fa-facebook"></i></a>
                        <a href="#"><i class="fa fa-linkedin"></i></a>
                    </div>
                </div>
            </div>

            <div class="col-md-4 col-sm-4">
                <div class="team-card wow fadeInUp" data-wow-delay="0.2s">
                    <img src="assets/about-img/photo-1573496359142-b8d87734a5a2.avif" alt="Team Member">
                    <h4>Sarah Johnson</h4>
                    <p>Head of Quality Assurance</p>
                    <div class="team-social">
                        <a href="#"><i class="fa fa-twitter"></i></a>
                        <a href="#"><i class="fa fa-facebook"></i></a>
                        <a href="#"><i class="fa fa-linkedin"></i></a>
                    </div>
                </div>
            </div>

            <div class="col-md-4 col-sm-4">
                <div class="team-card wow fadeInUp" data-wow-delay="0.3s">
                    <img src="assets/about-img/photo-1519085360753-af0119f7cbe7.avif" alt="Team Member">
                    <h4>Michael Rodriguez</h4>
                    <p>Tech Specialist</p>
                    <div class="team-social">
                        <a href="#"><i class="fa fa-twitter"></i></a>
                        <a href="#"><i class="fa fa-facebook"></i></a>
                        <a href="#"><i class="fa fa-linkedin"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <?php include('includes/brands-slider.php');?>
    </div><!-- /.container -->
</div><!-- /.body-content -->

    <?php include('includes/footer.php');?>

    <script src="assets/js/jquery-1.11.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/bootstrap-hover-dropdown.min.js"></script>
    <script src="assets/js/owl.carousel.min.js"></script>
    <script src="assets/js/echo.min.js"></script>
    <script src="assets/js/jquery.easing-1.3.min.js"></script>
    <script src="assets/js/bootstrap-slider.min.js"></script>
        <script src="assets/js/jquery.rateit.min.js"></script>
        <script type="text/javascript" src="assets/js/lightbox.min.js"></script>
        <script src="assets/js/bootstrap-select.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/scripts.js"></script>
      <script src="js/subscribe.js"></script>
    <script>
    echo.init({
        offset: 100,
        throttle: 250,
        unload: false
    });
</script>
</body>

</html>
