<?php
session_start();
error_reporting(0);
include('includes/config.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="description" content="Find answers to common questions about pet adoption, care, and our services at Fairly Used Electronics.">
    <meta name="author" content="">
       
    <meta name="keywords" content="FAQ, pet adoption, pet care, puppies, kittens">
       
    <meta name="robots" content="all">

        <title>Fairly Used Electronics | Frequently Asked Questions</title>

       
    <!-- Bootstrap Core CSS -->
       
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
       
    <!-- Customizable CSS -->
       
    <link rel="stylesheet" href="assets/css/main.css">
       
    <link rel="stylesheet" href="assets/css/green.css">
       
    <link rel="stylesheet" href="assets/css/owl.carousel.css">
    <link rel="stylesheet" href="assets/css/owl.transitions.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/rateit.css">
    <link rel="stylesheet" href="assets/css/bootstrap-select.min.css">

    <!-- Icons/Glyphs -->
    <link rel="stylesheet" href="assets/css/font-awesome.min.css">

           
    <!-- Fonts --> 
    <link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,700' rel='stylesheet' type='text/css'>

    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- ============================================================= -->
    <!-- ============== CUSTOM STYLES FOR REDESIGN =================== -->
    <!-- ============================================================= -->
    <style>
        .faq-hero {
            background: linear-gradient(rgba(45, 52, 61, 0.6), rgba(45, 52, 61, 0.6)), url('assets/about-img/photo-1548199973-03cce0bbc87b.avif') no-repeat center center;
            background-size: cover;
            color: white;
            padding: 80px 0;
            text-align: center;
        }

        .faq-hero h1 {
            color: white;
            font-size: 42px;
            font-weight: 700;
            text-shadow: 2px 2px 8px rgba(0, 0, 0, 0.5);
        }

        .faq-hero .lead {
            font-size: 20px;
            font-weight: 300;
        }

        .faq-container {
            background: #fff;
            padding: 40px;
            margin-top: -60px;
            /* Pulls the content up over the hero */
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 10;
        }

        /* Left Side Navigation */
        .faq-nav .nav-pills>li>a {
            border-radius: 5px;
            color: #555;
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }

        .faq-nav .nav-pills>li>a:hover {
            background-color: #f0f9e9;
            color: #59b210;
        }

        .faq-nav .nav-pills>li.active>a,
        .faq-nav .nav-pills>li.active>a:hover,
        .faq-nav .nav-pills>li.active>a:focus {
            background-color: #59b210;
            color: white;
        }

        .faq-nav h3 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #eee;
        }

        .sticky-nav {
            position: -webkit-sticky;
            /* For Safari */
            position: sticky;
            top: 20px;
            /* Adjust as needed for your sticky header height */
        }

        /* Right Side Content & Accordion */
        .faq-content .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eee;
        }

        .panel-group .panel {
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border: 1px solid #e9e9e9;
            margin-bottom: 20px;
        }

        .panel-default>.panel-heading {
            padding: 0;
            border-radius: 5px 5px 0 0;
            color: #333;
            background-color: #fff;
        }

        .panel-title {
            font-size: 16px;
            font-weight: 500;
        }

        .panel-title>a {
            display: block;
            padding: 20px;
            text-decoration: none;
            position: relative;
        }

        .panel-title>a:after {
            font-family: 'FontAwesome';
            content: "\f067";
            /* Plus icon */
            float: right;
            color: #59b210;
            transition: all 0.3s;
        }

        .panel-title>a.collapsed:after {
            content: "\f067";
            /* Plus icon */
        }

        .panel-title>a:not(.collapsed):after {
            content: "\f068";
            /* Minus icon */
            transform: rotate(180deg);
        }

        .panel-body {
            background: #fdfdfd;
            padding: 20px;
            border-top: 1px solid #e9e9e9;
            line-height: 1.8;
        }

        /* Final CTA Box */
        .contact-cta-box {
            background: #c1ffdd;
            padding: 40px;
            border-radius: 8px;
            text-align: center;
            margin-top: 40px;
            border: 1px solid #d4edda;
        }

        .contact-cta-box h3 {
            font-weight: 700;
        }

    </style>
</head>
   

<body class="cnt-home">

    <!-- ============================================== HEADER ============================================== -->
    <header class="header-style-1">
        <?php include('includes/top-header.php');?>
        <?php include('includes/main-header.php');?>
        <?php include('includes/menu-bar.php');?>
    </header>
    <!-- ============================================== HEADER : END ============================================== -->

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="index.php">Home</a></li>
                    <li class='active'>Frequently Asked Questions</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <!-- Hero Section -->
    <div class="faq-hero">
        <div class="container">
            <h1>How Can We Help?</h1>
            <p class="lead">Your questions, answered. Find help with Electronic sales, SamrtPhones, Laptops, and more.</p>
        </div>
    </div>

    <div class="body-content">
        <div class="container">
            <div class="faq-container">
                <div class="row">
                    <!-- ========================== Left Navigation ========================== -->
                    <div class="col-md-4">
                        <div class="sticky-nav">
                            <h3>Read by Category</h3>
                            <ul class="nav nav-pills nav-stacked faq-nav">
                                <li class="active"><a href="#general-questions" data-toggle="pill">General Questions</a></li>
                                <li><a href="#product-purchase" data-toggle="pill">Product Purchase</a></li>
                                <li><a href="#product-care" data-toggle="pill">Device Care &amp; Warranty</a></li>
                                <li><a href="#website-account" data-toggle="pill">Website &amp; Account</a></li>
                            </ul>

                            <hr>
                            <!-- Search Bar moved to the side navigation -->
                            <h4>Search Questions</h4>
                            <div class="search-faq">
                                <div class="input-group">
                                    <input type="text" id="faqSearchInput" class="form-control" placeholder="Type to search...">
                                    <span class="input-group-btn">
                                        <button class="btn btn-primary" type="button"><i class="fa fa-search"></i></button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ========================== Right Content Area ========================== -->
                    <div class="col-md-8">
                        <div class="tab-content faq-content">
                            <!-- General Questions Section -->
                            <div class="tab-pane active" id="general-questions">
                                <h3 class="section-title">General Questions</h3>
                                <div class="panel-group" id="accordion1">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion1" href="#collapse1">What is Fairly Used Electronics?</a></h4>
                                        </div>
                                        <div id="collapse1" class="panel-collapse collapse in">
                                            <div class="panel-body">
                                                <p>Fairly Used Electronics is your trusted marketplace for quality pre-owned smartphones and laptops. Every device is tested, verified, and guaranteed to give you excellent value at an affordable price.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion1" href="#collapse2" class="collapsed">How does the purchase process work?</a></h4>
                                        </div>
                                        <div id="collapse2" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>It’s simple: 1) Browse our catalog, 2) Add your chosen device to the cart, 3) Checkout securely, 4) Select your delivery option, and 5) Receive your device. Most orders are delivered within 2–5 business days.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion1" href="#collapse3" class="collapsed">What are your operating hours?</a></h4>
                                        </div>
                                        <div id="collapse3" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Our support team is available Mon–Fri (9am–6pm) and Sat (10am–4pm). You can browse our website and place orders 24/7.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Product Purchase Section -->
                            <div class="tab-pane" id="product-purchase">
                                <h3 class="section-title">Product Purchase</h3>
                                <div class="panel-group" id="accordion2">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion2" href="#collapse4">What should I know before buying a used device?</a></h4>
                                        </div>
                                        <div id="collapse4" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>All devices are inspected, tested, and graded by condition. We provide full details on specifications, cosmetic condition, and available accessories before purchase so you can shop with confidence.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion2" href="#collapse5" class="collapsed">How much do fairly used phones and laptops cost?</a></h4>
                                        </div>
                                        <div id="collapse5" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Prices vary depending on the brand, model, and condition. Entry-level devices may start from as low as $100, while premium flagship models are still more affordable compared to new retail prices.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion2" href="#collapse6" class="collapsed">Can I return a product if I’m not satisfied?</a></h4>
                                        </div>
                                        <div id="collapse6" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Yes, we have a 7-day return policy for refunds or exchanges, provided the item is returned in its original condition. Customer satisfaction is our priority.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion2" href="#collapse7" class="collapsed">Do you ship internationally?</a></h4>
                                        </div>
                                        <div id="collapse7" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Yes, we ship to selected countries. International orders may require additional shipping fees, customs clearance, and taxes depending on your location.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Device Care & Warranty Section -->
                            <div class="tab-pane" id="product-care">
                                <h3 class="section-title">Device Care &amp; Warranty</h3>
                                <div class="panel-group" id="accordion3">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion3" href="#collapse8">Do your products come with a warranty?</a></h4>
                                        </div>
                                        <div id="collapse8" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Yes, every device comes with a 30–90 day warranty depending on the product. Extended warranty options are also available at checkout.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion3" href="#collapse9" class="collapsed">Are accessories included?</a></h4>
                                        </div>
                                        <div id="collapse9" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>We include essential accessories such as chargers and cables whenever possible. Specific details are listed in each product description.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion3" href="#collapse10" class="collapsed">Do you offer after-sales support?</a></h4>
                                        </div>
                                        <div id="collapse10" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Yes! Our team provides after-sales support, technical guidance, and assistance with warranty claims to ensure you enjoy a smooth experience with your device.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Website & Account Section -->
                            <div class="tab-pane" id="website-account">
                                <h3 class="section-title">Website & Account</h3>
                                <div class="panel-group" id="accordion4">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion4" href="#collapse11">How do I create an account?</a></h4>
                                        </div>
                                        <div id="collapse11" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Click the "Sign Up" button at the top of any page, then enter your details. With an account, you can save favorites, track orders, and manage returns easily.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion4" href="#collapse12" class="collapsed">How often are products updated?</a></h4>
                                        </div>
                                        <div id="collapse12" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Our inventory is updated daily in real-time. If you don’t find what you need today, check back often or subscribe for product alerts.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h4 class="panel-title"><a data-toggle="collapse" data-parent="#accordion4" href="#collapse13" class="collapsed">Is my personal information secure?</a></h4>
                                        </div>
                                        <div id="collapse13" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>Yes, your data is secure. We use SSL encryption and follow strict privacy policies. We never sell or share your personal information.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- /.tab-content -->
                    </div> <!-- /.col-md-8 -->
                </div> <!-- /.row -->

                <!-- Final Call to Action -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="contact-cta-box">
                            <h3>Can't Find Your Answer?</h3>
                            <p>Our support team is ready to help with any questions about fairly used smartphones and laptops.</p>
                            <a href="contact.php" class="btn btn-primary">Contact Support</a>
                        </div>
                    </div>
                </div>
            </div><!-- /.faq-container -->
            <?php include('includes/brands-slider.php');?>
        </div><!-- /.container -->
    </div><!-- /.body-content -->


    <?php include('includes/footer.php');?>

    <script src="assets/js/jquery-1.11.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/bootstrap-hover-dropdown.min.js"></script>
    <script src="assets/js/owl.carousel.min.js"></script>
    <script src="assets/js/echo.min.js"></script>
    <script src="assets/js/jquery.easing-1.3.min.js"></script>
    <script src="assets/js/bootstrap-slider.min.js"></script>
        <script src="assets/js/jquery.rateit.min.js"></script>
        <script type="text/javascript" src="assets/js/lightbox.min.js"></script>
        <script src="assets/js/bootstrap-select.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/scripts.js"></script>
      <script src="js/subscribe.js"></script>

    <!-- ============================================================= -->
    <!-- ============== CUSTOM SCRIPT FOR FAQ PAGE =================== -->
    <!-- ============================================================= -->
    <script>
        $(document).ready(function() {
            // Activate the first tab and link on page load
            $('.faq-nav li:first-child').addClass('active');
            $('.faq-content .tab-pane:first-child').addClass('active');

            // Smooth scroll for nav links (optional but nice)
            $('.faq-nav a').on('click', function(e) {
                e.preventDefault();
                $(this).tab('show');
                // The data-toggle="pill" handles the tab switching automatically
            });

            // Live Search Functionality
            $('#faqSearchInput').on('keyup', function() {
                var searchTerm = $(this).val().toLowerCase();

                // Hide all sections first
                $('.faq-content .tab-pane').hide();
                $('#no-results').remove(); // Remove previous no results message

                var resultsFound = false;

                if (searchTerm.length > 2) {
                    // Loop through each question panel
                    $('.panel-group .panel').each(function() {
                        var question = $(this).find('.panel-title a').text().toLowerCase();
                        var answer = $(this).find('.panel-body').text().toLowerCase();

                        if (question.indexOf(searchTerm) !== -1 || answer.indexOf(searchTerm) !== -1) {
                            $(this).show();
                            // Show the parent tab-pane section
                            $(this).closest('.tab-pane').show();
                            resultsFound = true;
                        } else {
                            $(this).hide();
                        }
                    });

                    if (!resultsFound) {
                        $('.faq-content').append('<div id="no-results" class="text-center"><h3>No Results Found</h3><p>Sorry, we couldn\'t find any answers matching your search.</p></div>');
                    }

                } else {
                    // If search is cleared, show the active tab's content
                    var activeTabId = $('.faq-nav li.active a').attr('href');
                    $(activeTabId).show();
                    $('.panel-group .panel').show(); // Show all panels within the active tab
                }
            });
        });

    </script>
    <script>
        echo.init({
            offset: 100,
            throttle: 250,
            unload: false
        });

    </script>
</body>

</html>
