$(document).ready(function () {
    $('#contactForm').on('submit', function (e) {
        e.preventDefault();

        // Clear previous messages
        $('.help-block').text('');
        $('#form-response').removeClass('alert-danger alert-success').hide().text('');

        var isValid = true;

        // Validation
        if ($('#name').val().trim() === '') {
            $('#name').next('.help-block').text('*Name is required');
            isValid = false;
        }

        var emailVal = $('#email').val().trim();
        if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(emailVal)) {
            $('#email').next('.help-block').text('*Valid email is required');
            isValid = false;
        }

        if ($('#message').val().trim() === '') {
            $('#message').next('.help-block').text('*Message is required');
            isValid = false;
        }

        // If valid, submit via AJAX
        if (isValid) {
            $('#sendMessageButton').prop('disabled', true)
                .html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Sending...');

            $.ajax({
                url: 'mail/ask_about_email.php',
                type: 'POST',
                data: $('#contactForm').serialize(),
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        $('#form-response')
                            .addClass('alert alert-success')
                            .html('<i class="fas fa-check-circle"></i> ' + response.message)
                            .fadeIn();

                        $('#contactForm')[0].reset();
                    } else {
                        $('#form-response')
                            .addClass('alert alert-danger')
                            .html('<i class="fas fa-exclamation-circle"></i> ' + response.message)
                            .fadeIn();

                        $.each(response.errors, function (field, message) {
                            $('[name="' + field + '"]').next('.help-block').text(message);
                        });
                    }
                },
                error: function () {
                    $('#form-response')
                        .addClass('alert alert-danger')
                        .html('<i class="fas fa-exclamation-circle"></i> Connection error. Please try again.')
                        .fadeIn();
                },
                complete: function () {
                    $('#sendMessageButton').prop('disabled', false).text('Send');
                }
            });
        }
    });
});
