// form-validation.js
$(document).ready(function() {
    $('#contactForm').on('submit', function(e) {
        e.preventDefault();
        
        // Clear previous messages
        $('.help-block').text('');
        $('#form-response').removeClass('alert-danger alert-success').text('');
        
        // Get form data
        var formData = $(this).serialize();
        
        // Client-side validation (optional but recommended)
        var isValid = true;
        
        if ($('#name').val().trim() === '') {
            $('#name').next('.help-block').text('*Name is required');
            isValid = false;
        }
        
        if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test($('#email').val())) {
            $('#email').next('.help-block').text('*Valid email is required');
            isValid = false;
        }
        
        if ($('#subject').val().trim() === '') {
            $('#subject').next('.help-block').text('*Subject is required');
            isValid = false;
        }
        
        if ($('#message').val().trim() === '') {
            $('#message').next('.help-block').text('*Message is required');
            isValid = false;
        }
        
        if (isValid) {
            // Show loading state
            $('#sendMessageButton').prop('disabled', true)
                .html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Sending...');
            
            // THIS IS WHERE THE FORM GETS SENT TO mail/send_email.php
            $.ajax({
                url: '../mail/send_email.php', // Explicit path to processor
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Show success message on page
                        $('#form-response')
                            .addClass('alert alert-success')
                            .html('<i class="fas fa-check-circle"></i> ' + response.message)
                            .fadeIn();
                        
                        // Optional: Clear form
                        $('#contactForm')[0].reset();
                    } else {
                        // Show error message
                        $('#form-response')
                            .addClass('alert alert-danger')
                            .html('<i class="fas fa-exclamation-circle"></i> ' + response.message)
                            .fadeIn();
                        
                        // Display field-specific errors
                        $.each(response.errors, function(field, message) {
                            $('#' + field).next('.help-block').text(message);
                        });
                    }
                },
                error: function(xhr) {
                    $('#form-response')
                        .addClass('alert alert-danger')
                        .html('<i class="fas fa-exclamation-circle"></i> Connection error. Please try again.')
                        .fadeIn();
                },
                complete: function() {
                    $('#sendMessageButton').prop('disabled', false).text('Send Request');
                }
            });
        }
    });
});