$(document).ready(function () {
    $('#subscribeForm').on('submit', function (e) {
        e.preventDefault();

        // Clear previous messages
        $('.help-block').text('');
        $('#subscribe-response').removeClass('alert-success alert-danger').hide().text('');

        var emailVal = $('#subscriberEmail').val().trim();
        var isValid = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(emailVal);

        if (!isValid) {
            $('#subscriberEmail').next('.help-block').text('*Valid email is required');
            return;
        }

        $('#subscribeButton').prop('disabled', true).text('Subscribing...');

        $.ajax({
            url: 'mail/subscribe.php', // Adjust path if needed
            type: 'POST',
            data: { email: emailVal },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $('#subscribe-response')
                        .addClass('alert alert-success')
                        .html('<i class="fas fa-check-circle"></i> ' + response.message)
                        .fadeIn();
                    $('#subscribeForm')[0].reset();
                } else {
                    $('#subscribe-response')
                        .addClass('alert alert-danger')
                        .html('<i class="fas fa-exclamation-circle"></i> ' + response.message)
                        .fadeIn();
                }
            },
            error: function () {
                $('#subscribe-response')
                    .addClass('alert alert-danger')
                    .html('<i class="fas fa-exclamation-circle"></i> Connection error. Please try again.')
                    .fadeIn();
            },
            complete: function () {
                $('#subscribeButton').prop('disabled', false).text('Subscribe');
            }
        });
         return false; // ensures form doesn't submit normally
    });
});
