<?php
session_start();
// If config.php is one folder above 'mail/'
include __DIR__ . '/../includes/config.php';

// Include PHPMailer (verify these paths are correct)
require '/home/strikyoo/public_html/PHPMailer-master/Exception.php';
require '/home/strikyoo/public_html/PHPMailer-master/PHPMailer.php';
require '/home/strikyoo/public_html/PHPMailer-master/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Now $con should be available
if(!$con){
    die("Database connection failed: " . mysqli_connect_error());
}

if(strlen($_SESSION['login'])==0) {   
    header('location:login.php');
    exit;
}

if($_SERVER['REQUEST_METHOD'] === 'POST') {

    $uid = $_SESSION['id'];

    // Validate payment method
    if(empty($_POST['paymethod'])){
        die("Payment method is required.");
    }

    $paymethod = $_POST['paymethod'];

    // Update payment method in orders table
    mysqli_query($con,"UPDATE orders SET paymentMethod='$paymethod' WHERE userId='$uid' AND paymentMethod IS NULL");

    // Fetch user info
    $userQuery = mysqli_query($con, "SELECT email, name FROM users WHERE id='$uid'");
    $userData = mysqli_fetch_assoc($userQuery);
    $userEmail = $userData['email'];
    $userName  = $userData['name'];

    if(!filter_var($userEmail, FILTER_VALIDATE_EMAIL)){
        die("Invalid user email.");
    }

   // Fetch order items with order ID
$itemsQuery = mysqli_query($con,"
    SELECT orders.id AS orderId, products.productName, orders.quantity 
    FROM orders 
    JOIN products ON products.id = orders.productId 
    WHERE orders.userId='$uid' 
      AND orders.paymentMethod='$paymethod'
");
    
    // Build email table
    $orderItemsTable = "<table border='1' cellpadding='8' cellspacing='0' style='border-collapse:collapse;'>
        <tr>
        <th>OrderID</th>
          <th>Product</th>
          <th>Quantity</th>          
        </tr>";

    while($item = mysqli_fetch_assoc($itemsQuery)) {
        $orderItemsTable .= "<tr>
            <td>".$item['orderId']."</td>
            <td>".$item['productName']."</td>
            <td>".$item['quantity']."</td>            
        </tr>";
    }
    $orderItemsTable .= "</table>";

    // Send email
    $mail = new PHPMailer(true);

    try {
       $mail->isSMTP();
            $mail->Host = 'server371.web-hosting.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'contact@fairlyusedelectronics.com';
            $mail->Password = 'fairly_Used_elect-123';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; 
            $mail->Port = 465;
            $mail->CharSet = 'UTF-8';

        $mail->setFrom('contact@fairlyusedelectronics.com', 'Fairly Used Electronics');
        $mail->addAddress($userEmail, $userName);

        $mail->isHTML(true);
        $mail->Subject = "Order Confirmation - Fairly Used Electronics";
        $mail->Body    = "
            <h2>Hello $userName,</h2>
            <p>Thank you for your order. Here are your order details:</p>
            $orderItemsTable
            <p><strong>Payment Method:</strong> $paymethod</p>
            <br>
            <p>We will notify you when your order is shipped.</p>
            <p>Best regards,<br>Fairly Used Electronics Team</p>
        ";

        $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: {$mail->ErrorInfo}");
    }

    // Clear cart and redirect
    unset($_SESSION['cart']);
    header('location:../order-history.php');
    exit;
}
?>
