<?php
// Enable error reporting (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set header for JSON response
header('Content-Type: application/json');

// Include PHPMailer (verify these paths are correct)
require '/home/strikyoo/public_html/PHPMailer-master/Exception.php';
require '/home/strikyoo/public_html/PHPMailer-master/PHPMailer.php';
require '/home/strikyoo/public_html/PHPMailer-master/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Initialize response
$response = [
    'success' => false,
    'message' => '',
    'errors' => []
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize function
    function clean_input($data) {
        return htmlspecialchars(strip_tags(trim($data)));
    }
    
    // Honeypot field validation
    if (!empty($_POST['honeypot'])) {
        // Silent fail for bots
        $response['success'] = true; // Pretend it was successful
        echo json_encode($response);
        exit;
    }

    // Validate Name
    $name = isset($_POST['name']) ? clean_input($_POST['name']) : '';
    if (empty($name)) {
        $response['errors']['name'] = "Full name is required.";
    } elseif (strlen($name) < 2) {
        $response['errors']['name'] = "Name must be at least 2 characters.";
    }

    // Validate Email
    $email = isset($_POST['email']) ? clean_input($_POST['email']) : '';
    if (empty($email)) {
        $response['errors']['email'] = "Email is required.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['errors']['email'] = "Invalid email format.";
    }

    // Validate Subject
    $subject = isset($_POST['subject']) ? clean_input($_POST['subject']) : '';
    if (empty($subject) || $subject === 'Select A Service') {
        $response['errors']['subject'] = "Please select a service.";
    }

   // Validate and Set Default for Message
$message = isset($_POST['message']) ? clean_input($_POST['message']) : '';

// Check if the message is empty after cleaning
if (empty($message)) {
    // Instead of creating an error, set your desired default value.
    $message = "No message provided by user.";
}

// Now, the $message variable will either contain the user's message
// or the default text, and no error will be generated.

    // Only proceed if no errors
    if (empty($response['errors'])) {
        $mail = new PHPMailer(true);

        try {
            // Server settings
            $mail->SMTPDebug = 3; // or 3 for more details
$mail->Debugoutput = function($str, $level) {
    error_log("PHPMailer Debug (Level $level): $str");
};
            $mail->isSMTP();
            $mail->Host = 'server371.web-hosting.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'contact@fairlyusedelectronics.com';
            $mail->Password = 'fairly_Used_elect-123';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; 
            $mail->Port = 465;
            $mail->CharSet = 'UTF-8';

            // Recipients
            $mail->setFrom('contact@fairlyusedelectronics.com', 'Fairly Used Electronics Contact Form');
            $mail->addAddress('contact@fairlyusedelectronics.com', 'Fairly Used Electronics Admin');
            
            // Add reply-to only if email is valid
            if (!empty($email) && empty($response['errors']['email'])) {
                $mail->addReplyTo($email, $name);
            }

            // Content
            $mail->isHTML(true);
            $mail->Subject = "New Contact: " . $subject;
            $mail->Body = "
                <h2>New Contact Form Submission</h2>
                <p><strong>Name:</strong> {$name}</p>
                <p><strong>Email:</strong> {$email}</p>
                <p><strong>Service:</strong> {$subject}</p>
                <p><strong>Message:</strong></p>
                <div>" . nl2br($message) . "</div>
            ";
            
            // Plain text version
            $mail->AltBody = "Name: {$name}\nEmail: {$email}\nService: {$subject}\nMessage:\n{$message}";

            if ($mail->send()) {
                $response['success'] = true;
                $response['message'] = 'Your message has been sent successfully!';
            } else {
                $response['message'] = 'Message could not be sent. Please try again later.';
            }
        } catch (Exception $e) {
           error_log('Mailer Error: ' . $mail->ErrorInfo);
    $response['message'] = 'Mailer Error: ' . $mail->ErrorInfo; // Show actual reason
        }
    } else {
        $response['message'] = 'Please correct the errors below.';
    }
} else {
    $response['message'] = 'Invalid request method.';
}

// Return JSON response
echo json_encode($response);
exit;
?>