<?php
session_start();
error_reporting(0);
include('includes/config.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="description" content="Privacy Policy for Fairly Used Electronics. Learn how we collect, use, and protect your personal information.">
    <meta name="author" content="">
       
    <meta name="keywords" content="privacy policy, data protection, pet store privacy">
       
    <meta name="robots" content="all">

        <title>Fairly Used Electronics | Privacy Policy</title>

       
    <!-- Bootstrap Core CSS -->
       
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
       
    <!-- Customizable CSS -->
       
    <link rel="stylesheet" href="assets/css/main.css">
       
    <link rel="stylesheet" href="assets/css/green.css">
       
    <link rel="stylesheet" href="assets/css/owl.carousel.css">
    <link rel="stylesheet" href="assets/css/owl.transitions.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/rateit.css">
    <link rel="stylesheet" href="assets/css/bootstrap-select.min.css">

    <!-- Icons/Glyphs -->
    <link rel="stylesheet" href="assets/css/font-awesome.min.css">

           
    <!-- Fonts --> 
    <link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,700' rel='stylesheet' type='text/css'>

    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- ============================================================= -->
    <!-- ============== CUSTOM STYLES FOR REDESIGN =================== -->
    <!-- ============================================================= -->
    <style>
        body {
            background-color: #f4f6f8;
        }    

        .policy-hero {
            background: linear-gradient(rgba(45, 52, 61, 0.6), rgba(45, 52, 61, 0.6)), url('https://images.unsplash.com/photo-1554629947-334ff61d85dc?ixlib=rb-4.0.3&auto=format&fit=crop&w=1500&q=80') no-repeat center center;
            background-size: cover;
            color: white;
            padding: 80px 0;
            text-align: center;
        }

        .policy-hero h1 {
            color: white;
            font-size: 42px;
            font-weight: 700;
            text-shadow: 2px 2px 8px rgba(0, 0, 0, 0.5);
        }

        .policy-hero .lead {
            font-size: 20px;
            font-weight: 300;
        }

        .policy-container {
            background: #fff;
            padding: 40px;
            margin-top: -60px;
            /* Pulls the content up over the hero */
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 10;
        }

        /* Left Side Navigation */
        .policy-nav .nav-pills>li>a {
            border-radius: 5px;
            color: #555;
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }

        .policy-nav .nav-pills>li>a:hover {
            background-color: #f0f9e9;
            color: #59b210;
        }

        .policy-nav .nav-pills>li.active>a,
        .policy-nav .nav-pills>li.active>a:hover,
        .policy-nav .nav-pills>li.active>a:focus {
            background-color: #59b210;
            color: white;
        }

        .policy-nav h3 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #eee;
        }

        .sticky-nav {
            position: -webkit-sticky;
            /* For Safari */
            position: sticky;
            top: 20px;
            /* Adjust as needed for your sticky header height */
            align-self: flex-start;
            background: #fff;
            border: 1px solid #eee;
            z-index: 10;
        }

        /* Right Side Content */
        .policy-content .policy-section {
            margin-bottom: 50px;
        }

        .policy-content .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eee;
            color: #333;
        }

        .policy-content .section-title .fa {
            margin-right: 15px;
            color: #59b210;
        }

        .policy-content p,
        .policy-content li {
            line-height: 1.8;
            color: #555;
        }

        .policy-content ul {
            padding-left: 20px;
            list-style-type: disc;
        }

        .effective-date {
            background-color: #f0f9e9;
            border-left: 4px solid #59b210;
            padding: 15px 20px;
            border-radius: 5px;
            margin-bottom: 40px;
        }

    </style>
</head>
   

<body class="cnt-home">

    <!-- ============================================== HEADER ============================================== -->
    <header class="header-style-1">
        <?php include('includes/top-header.php');?>
        <?php include('includes/main-header.php');?>
        <?php include('includes/menu-bar.php');?>
    </header>
    <!-- ============================================== HEADER : END ============================================== -->

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="index.php">Home</a></li>
                    <li class='active'>Privacy Policy</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <!-- Hero Section -->
    <div class="policy-hero">
        <div class="container">
            <h1>Privacy Policy</h1>
            <p class="lead">Your privacy is important to us. Here's how we protect your information.</p>
        </div>
    </div>

    <div class="body-content">
    <div class="container">
        <div class="policy-container">
            <div class="row">
                <!-- ========================== Left Navigation ========================== -->
                <div class="col-md-4">
                    <div class="sticky-nav">
                        <h3>Policy Sections</h3>
                        <ul class="nav nav-pills nav-stacked policy-nav">
                            <li class="active"><a href="#introduction">Introduction</a></li>
                            <li><a href="#info-collect">1. Information We Collect</a></li>
                            <li><a href="#info-use">2. How We Use Your Information</a></li>
                            <li><a href="#info-share">3. Sharing of Information</a></li>
                            <li><a href="#info-cookies">4. Cookies &amp; Tracking</a></li>
                            <li><a href="#info-protection">5. Data Protection</a></li>
                            <li><a href="#info-rights">6. Your Rights</a></li>
                            <li><a href="#info-contact">7. Contact Us</a></li>
                        </ul>
                    </div>
                </div>

                <!-- ========================== Right Content Area ========================== -->
                <div class="col-md-8">
                    <div class="policy-content">
                        <div class="effective-date">
                            <p class="text-muted" style="margin:0;"><strong>Effective Date:</strong> 20th September 2025</p>
                        </div>

                        <div id="introduction" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-info-circle"></i> Introduction</h3>
                            <p>At Fairly Used Electronics, your privacy is very important to us. This Privacy Policy explains how we collect, use, and protect your information when you browse or shop on our website. By using our services, you agree to the collection and use of your data as described in this policy.</p>
                        </div>

                        <div id="info-collect" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-database"></i> 1. Information We Collect</h3>
                            <p><strong>Personal Information:</strong> When you create an account, place an order, or contact us, we may collect your name, email address, phone number, and billing/shipping details.</p>
                            <p><strong>Non-Personal Information:</strong> We may automatically collect non-personal data such as browser type, device details, IP address, and browsing activity to help improve our website and services.</p>
                        </div>

                        <div id="info-use" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-cogs"></i> 2. How We Use Your Information</h3>
                            <p>We use the collected information for purposes such as:</p>
                            <ul>
                                <li>To process and deliver your smartphone or laptop orders.</li>
                                <li>To provide reliable customer service and after-sales support.</li>
                                <li>To notify you of order updates, promotions, or policy changes.</li>
                                <li>To improve our website functionality, product listings, and overall shopping experience.</li>
                                <li>To send promotional emails and special offers (only if you opt-in).</li>
                            </ul>
                        </div>

                        <div id="info-share" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-share-alt"></i> 3. Sharing of Information</h3>
                            <p>We do not sell or rent your personal data. We only share information with trusted service providers such as payment processors, shipping companies, and IT partners, who assist us in running our store. These partners are required to keep your information secure and confidential.</p>
                        </div>

                        <div id="info-cookies" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-circle-o-notch"></i> 4. Cookies & Tracking</h3>
                            <p>Our website uses cookies to enhance your shopping experience. Cookies help us remember your preferences, analyze traffic, and improve site performance. You can choose to accept or refuse cookies by adjusting your browser settings.</p>
                        </div>

                        <div id="info-protection" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-shield"></i> 5. Data Protection</h3>
                            <p>We take your security seriously and use industry-standard encryption and safeguards to protect your personal data. However, please note that no online transmission or storage method is 100% secure, and we encourage you to protect your login credentials at all times.</p>
                        </div>

                        <div id="info-rights" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-user"></i> 6. Your Rights</h3>
                            <p>You have the right to:</p>
                            <ul>
                                <li>Request access to the personal data we store about you.</li>
                                <li>Request corrections if any of your details are inaccurate.</li>
                                <li>Request deletion of your account or personal data, where applicable.</li>
                                <li>Opt-out of marketing communications at any time.</li>
                            </ul>
                        </div>

                        <div id="info-contact" class="policy-section">
                            <h3 class="section-title"><i class="fa fa-envelope"></i> 7. Contact Us</h3>
                            <p>If you have questions about this Privacy Policy or how we handle your information, please contact us:</p>
                            <p><strong>Email:</strong> <a href="mailto:support@fairlyusedelectronics.com">support@fairlyusedelectronics.com</a></p>
                            <p><strong>Phone:</strong> +66 65 092 8864</p>
                        </div>
                    </div> <!-- /.policy-content -->
                </div> <!-- /.col-md-8 -->
            </div> <!-- /.row -->
        </div><!-- /.policy-container -->
    </div><!-- /.container -->
</div><!-- /.body-content -->


    <?php include('includes/footer.php');?>

    <script src="assets/js/jquery-1.11.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/bootstrap-hover-dropdown.min.js"></script>
    <script src="assets/js/owl.carousel.min.js"></script>
    <script src="assets/js/echo.min.js"></script>
    <script src="assets/js/jquery.easing-1.3.min.js"></script>
    <script src="assets/js/bootstrap-slider.min.js"></script>
        <script src="assets/js/jquery.rateit.min.js"></script>
        <script type="text/javascript" src="assets/js/lightbox.min.js"></script>
        <script src="assets/js/bootstrap-select.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/scripts.js"></script>
      <script src="js/subscribe.js"></script>

    <!-- ============================================================= -->
    <!-- ============== CUSTOM SCRIPT FOR POLICY PAGE ================ -->
    <!-- ============================================================= -->
    <script>
        $(document).ready(function() {
            // Smooth scroll for navigation links
            $('.policy-nav a').on('click', function(event) {
                if (this.hash !== "") {
                    event.preventDefault();
                    var hash = this.hash;
                    $('html, body').animate({
                        scrollTop: $(hash).offset().top - 100 // Adjust -100 for sticky header offset
                    }, 800, function() {
                        // window.location.hash = hash; // Optional: adds hash to URL
                    });

                    // Manually update active class
                    $('.policy-nav li').removeClass('active');
                    $(this).parent('li').addClass('active');
                }
            });
        });

    </script>
    <script>
    echo.init({
        offset: 100,
        throttle: 250,
        unload: false
    });
</script>
</body>

</html>
