<?php
session_start();
error_reporting(0);
include('includes/config.php');
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<!-- Meta -->
		<meta charset="utf-8">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
		<meta name="description" content="Terms and Conditions for using the Fairly Used Electronics website and services.">
		<meta name="author" content="">
	    <meta name="keywords" content="terms, conditions, pet store, legal">
	    <meta name="robots" content="all">

	    <title>Fairly Used Electronics | Terms &amp; Conditions</title>

	    <!-- Bootstrap Core CSS -->
	    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
	    
	    <!-- Customizable CSS -->
	    <link rel="stylesheet" href="assets/css/main.css">
	    <link rel="stylesheet" href="assets/css/green.css">
	    <link rel="stylesheet" href="assets/css/owl.carousel.css">
		<link rel="stylesheet" href="assets/css/owl.transitions.css">
		<link rel="stylesheet" href="assets/css/animate.min.css">
		<link rel="stylesheet" href="assets/css/rateit.css">
		<link rel="stylesheet" href="assets/css/bootstrap-select.min.css">

		<!-- Icons/Glyphs -->
		<link rel="stylesheet" href="assets/css/font-awesome.min.css">

        <!-- Fonts --> 
		<link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,700' rel='stylesheet' type='text/css'>
		
		<!-- Favicon -->
		<link rel="shortcut icon" href="assets/images/favicon.ico">

		<!-- ============================================================= -->
		<!-- ============== CUSTOM STYLES FOR REDESIGN =================== -->
		<!-- ============================================================= -->
		<style>
			body {
				background-color: #f4f6f8;
			}
		.terms-hero {
				background: linear-gradient(rgba(45, 52, 61, 0.6), rgba(45, 52, 61, 0.6)), url('https://images.unsplash.com/photo-1517836357463-d25dfeac3438?ixlib=rb-4.0.3&auto=format&fit=crop&w=1500&q=80') no-repeat center center;
				background-size: cover;
				color: white;
				padding: 80px 0;
				text-align: center;
			}
			.terms-hero h1 {
                color: white;
				font-size: 42px;
				font-weight: 700;
				text-shadow: 2px 2px 8px rgba(0,0,0,0.5);
			}
			.terms-hero .lead {
				font-size: 20px;
				font-weight: 300;
			}
			
			.terms-container {
				background: #fff;
				padding: 40px;
				margin-top: -60px; /* Pulls the content up over the hero */
				border-radius: 8px;
				box-shadow: 0 10px 30px rgba(0,0,0,0.1);
				position: relative;
				z-index: 10;
			}

			/* Left Side Navigation */
			.terms-nav .nav-pills > li > a {
				border-radius: 5px;
				color: #555;
				font-weight: 500;
				padding: 12px 20px;
				transition: all 0.3s ease;
			}
			.terms-nav .nav-pills > li > a:hover {
				background-color: #f0f9e9;
				color: #59b210;
			}
			.terms-nav .nav-pills > li.active > a,
			.terms-nav .nav-pills > li.active > a:hover,
			.terms-nav .nav-pills > li.active > a:focus {
				background-color: #59b210;
				color: white;
			}
			.terms-nav h3 {
				font-size: 20px;
				font-weight: 700;
				margin-bottom: 20px;
				padding-bottom: 10px;
				border-bottom: 2px solid #eee;
			}
			.sticky-nav {
				position: -webkit-sticky; /* For Safari */
				position: sticky;
				top: 20px;
			}
			
			/* Right Side Content */
			.terms-content .terms-section {
				margin-bottom: 50px;
			}
			.terms-content .section-title {
				font-size: 24px;
				font-weight: 700;
				margin-bottom: 25px;
				padding-bottom: 15px;
				border-bottom: 2px solid #eee;
				color: #333;
			}
			.terms-content .section-title .fa {
				margin-right: 15px;
				color: #59b210;
			}
			.terms-content p, .terms-content li {
				line-height: 1.8;
				color: #555;
			}
			.terms-content ul {
				padding-left: 20px;
				list-style-type: disc;
			}
			.effective-date {
				background-color: #f0f9e9;
				border-left: 4px solid #59b210;
				padding: 15px 20px;
				border-radius: 5px;
				margin-bottom: 40px;
			}
			.note-box {
				background: #fff8e1;
				padding: 20px;
				border-radius: 5px;
				border-left: 4px solid #ffc107;
				margin: 20px 0;
			}
		</style>
	</head>
    <body class="cnt-home">
	
		<!-- ============================================== HEADER ============================================== -->
		<header class="header-style-1">
			<?php include('includes/top-header.php');?>
			<?php include('includes/main-header.php');?>
			<?php include('includes/menu-bar.php');?>
		</header>
		<!-- ============================================== HEADER : END ============================================== -->

		<div class="breadcrumb">
			<div class="container">
				<div class="breadcrumb-inner">
					<ul class="list-inline list-unstyled">
						<li><a href="index.php">Home</a></li>
						<li class='active'>Terms & Conditions</li>
					</ul>
				</div>
			</div>
		</div>

		<!-- Hero Section -->
		<div class="terms-hero">
			<div class="container">
				<h1>Terms & Conditions</h1>
				<p class="lead">Please read our terms carefully before using our services.</p>
			</div>
		</div>

		<div class="body-content">
    <div class="container">
        <div class="terms-container">
            <div class="row">
                <!-- ========================== Left Navigation ========================== -->
                <div class="col-md-4">
                    <div class="sticky-nav">
                        <h3>Document Sections</h3>
                        <ul class="nav nav-pills nav-stacked terms-nav">
                            <li class="active"><a href="#introduction">Introduction</a></li>
                            <li><a href="#use-of-website">1. Use of Website</a></li>
                            <li><a href="#products">2. Products</a></li>
                            <li><a href="#payments">3. Payments</a></li>
                            <li><a href="#warranty">4. Warranty & Responsibility</a></li>
                            <li><a href="#returns-refunds">5. Returns & Refunds</a></li>
                            <li><a href="#liability">6. Limitation of Liability</a></li>
                            <li><a href="#changes">7. Changes to Terms</a></li>
                            <li><a href="#contact">8. Contact Us</a></li>
                        </ul>
                    </div>
                </div>

                <!-- ========================== Right Content Area ========================== -->
                <div class="col-md-8">
                    <div class="terms-content">
                        <div class="effective-date">
                            <p class="text-muted" style="margin:0;"><strong>Last Updated:</strong> 20th September 2025</p>
                        </div>

                        <div id="introduction" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-gavel"></i> Introduction</h3>
                            <p>Welcome to Fairly Used Electronics! These Terms and Conditions govern your use of our website and the purchase of smartphones, laptops, and related accessories. By accessing or using our website, you agree to these terms. If you do not agree, please discontinue use of our services.</p>
                        </div>

                        <div id="use-of-website" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-desktop"></i> 1. Use of Website</h3>
                            <ul>
                                <li>You agree to use this website for lawful purposes only and in a manner that does not infringe on the rights of others.</li>
                                <li>You must be at least 18 years of age, or the age of majority in your jurisdiction, to make a purchase through our platform.</li>
                            </ul>
                        </div>

                        <div id="products" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-mobile"></i> 2. Products</h3>
                            <ul>
                                <li>All product details, including specifications, images, and prices, are provided for information purposes and may be updated without prior notice.</li>
                                <li>We make every effort to ensure accuracy but do not guarantee that all listings are error-free. Errors may be corrected at any time.</li>
                                <li>As our products are pre-owned, conditions may vary. Each product listing will indicate its specific condition (e.g., Like New, Excellent, Good, Fair).</li>
                            </ul>
                        </div>

                        <div id="payments" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-credit-card"></i> 3. Payments</h3>
                            <ul>
                                <li>All purchases must be completed using the approved payment methods available on our website.</li>
                                <li>Prices are listed exclusive of taxes and shipping costs unless otherwise stated.</li>
                                <li>Orders will only be processed once payment has been successfully received.</li>
                            </ul>
                        </div>

                        <div id="warranty" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-shield"></i> 4. Warranty & Responsibility</h3>
                            <ul>
                                <li>All products sold are pre-owned and may include limited warranties as described in each listing.</li>
                                <li>Fairly Used Electronics acts as a marketplace connecting buyers with trusted sellers. Responsibility for product authenticity and condition lies with the seller.</li>
                            </ul>
                            <div class="note-box">
                                <p><strong><i class="fa fa-info-circle"></i> Note:</strong> We encourage buyers to carefully review the condition details, specifications, and warranty information before completing a purchase.</p>
                            </div>
                        </div>

                        <div id="returns-refunds" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-undo"></i> 5. Returns & Refunds</h3>
                            <ul>
                                <li>Returns are accepted only under specific conditions (e.g., defective item, incorrect product received) and must comply with our return policy.</li>
                                <li>Refunds will be processed once the returned item is inspected and approved.</li>
                                <li>Products must be returned in the same condition in which they were delivered, with all accessories included.</li>
                            </ul>
                        </div>

                        <div id="liability" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-exclamation-circle"></i> 6. Limitation of Liability</h3>
                            <p>Fairly Used Electronics, its employees, and affiliates are not liable for:</p>
                            <ul>
                                <li>Any indirect, incidental, or consequential damages resulting from the use of our products.</li>
                                <li>Issues arising from third-party sellers or courier delays once the product has been dispatched.</li>
                            </ul>
                        </div>

                        <div id="changes" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-refresh"></i> 7. Changes to Terms</h3>
                            <p>We reserve the right to update these Terms and Conditions at any time. Any changes will be published on this page, and continued use of our site constitutes agreement to the revised terms.</p>
                        </div>

                        <div id="contact" class="terms-section">
                            <h3 class="section-title"><i class="fa fa-envelope"></i> 8. Contact Us</h3>
                            <p>If you have any questions about these Terms and Conditions, please contact us:</p>
                            <p><strong>Email:</strong> <a href="mailto:support@fairlyusedelectronics.com">support@fairlyusedelectronics.com</a></p>
                        </div>
                    </div> <!-- /.terms-content -->
                </div> <!-- /.col-md-8 -->
            </div> <!-- /.row -->
        </div><!-- /.terms-container -->
    </div><!-- /.container -->
</div><!-- /.body-content -->

		
		<?php include('includes/footer.php');?>
		
		<script src="assets/js/jquery-1.11.1.min.js"></script>
		<script src="assets/js/bootstrap.min.js"></script>
		<script src="assets/js/bootstrap-hover-dropdown.min.js"></script>
		<script src="assets/js/owl.carousel.min.js"></script>
		<script src="assets/js/echo.min.js"></script>
		<script src="assets/js/jquery.easing-1.3.min.js"></script>
		<script src="assets/js/bootstrap-slider.min.js"></script>
	    <script src="assets/js/jquery.rateit.min.js"></script>
	    <script type="text/javascript" src="assets/js/lightbox.min.js"></script>
	    <script src="assets/js/bootstrap-select.min.js"></script>
	    <script src="assets/js/wow.min.js"></script>
		<script src="assets/js/scripts.js"></script>
		  <script src="js/subscribe.js"></script>

		<!-- ============================================================= -->
		<!-- ============== CUSTOM SCRIPT FOR TERMS PAGE ================= -->
		<!-- ============================================================= -->
		<script>
			$(document).ready(function() {
				// Smooth scroll for navigation links
				$('.terms-nav a').on('click', function(event) {
					if (this.hash !== "") {
						event.preventDefault();
						var hash = this.hash;
						$('html, body').animate({
							scrollTop: $(hash).offset().top - 100 // Adjust -100 for your sticky header's height
						}, 800);
						
						// Manually update the active class on the nav link
						$('.terms-nav li').removeClass('active');
						$(this).parent('li').addClass('active');
					}
				});
			});
		</script>
        <script>
    echo.init({
        offset: 100,
        throttle: 250,
        unload: false
    });
</script>
	</body>
</html>
