<?php
session_start();
include_once 'includes/config.php';
$oid = intval($_GET['oid']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Fairly Used Electronics | Order Tracking Details</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

  <style>
    body {
      background: #f8f9fa;
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
    }
    .tracking-card {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.1);
      padding: 25px;
      margin-top: 40px;
    }
    .tracking-header {
      border-bottom: 2px solid #e9ecef;
      margin-bottom: 20px;
      padding-bottom: 10px;
    }
    .tracking-header h4 {
      font-weight: bold;
      color: #0d6efd;
    }
    .status-entry {
      background: #f1f3f5;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 15px;
    }
    .status-entry strong {
      color: #495057;
    }
    .delivered-msg {
      background: #d1e7dd;
      color: #0f5132;
      padding: 12px;
      border-radius: 8px;
      font-weight: 500;
      margin-top: 15px;
    }
    .btn-actions {
      margin-top: 20px;
    }
  </style>
</head>
<body>

<div class="container">
  <div class="tracking-card">
    <div class="tracking-header d-flex justify-content-between align-items-center">
      <h4><i class="fa-solid fa-box"></i> Order Tracking</h4>
      <span class="text-muted">Order ID: <strong>#<?php echo $oid; ?></strong></span>
    </div>

    <?php 
    $ret = mysqli_query($con, "SELECT * FROM ordertrackhistory WHERE orderId='$oid'");
    $num = mysqli_num_rows($ret);

    if ($num > 0) {
        while ($row = mysqli_fetch_array($ret)) { ?>
            <div class="status-entry">
              <p><strong>Date:</strong> <?php echo $row['postingDate']; ?></p>
              <p><strong>Status:</strong> <span class="badge bg-info"><?php echo $row['status']; ?></span></p>
              <p><strong>Remark:</strong> <?php echo $row['remark']; ?></p>
            </div>
        <?php } 
    } else { ?>
        <p class="text-danger">Order has not been processed yet. Pending Payment</p>
    <?php }

    $st = 'Delivered';
    $rt = mysqli_query($con, "SELECT * FROM orders WHERE id='$oid'");
    while ($num = mysqli_fetch_array($rt)) {
        $currrentSt = $num['orderStatus'];
    }
    if ($st == $currrentSt) { ?>
        <div class="delivered-msg">
          <i class="fa-solid fa-circle-check"></i> Product delivered successfully
        </div>
    <?php } ?>

    <!-- Action buttons -->
    <div class="btn-actions d-flex gap-2">
      <button class="btn btn-secondary" onclick="window.close()"><i class="fa fa-times"></i> Close</button>
      <button class="btn btn-primary" onclick="window.print()"><i class="fa fa-print"></i> Print</button>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
